#include <iostream>
#include <fstream>
#include <string.h>
#include <stdio.h>
#include <ilcplex/ilocplex.h>

#ifdef WIN64
#include <time.h>
#else 
#include <sys/shm.h>
#include <sys/types.h>
#endif

#define BIGM 10000
#define tab '\t'

typedef IloIntVarArray vetorvarint;
typedef IloNumVarArray vetorvarnum;
typedef IloBoolVarArray vetorvarbin;
typedef IloIntArray vetorint;
typedef IloNumArray vetornum;
typedef IloArray<IloNumVarArray> matrizvarnum;
typedef IloArray<IloIntVarArray> matrizvarint;
typedef IloArray<IloBoolVarArray> matrizvarbin;
typedef IloArray<IloIntArray> matrizint;
typedef IloArray<IloNumArray> matriznum;
typedef IloArray<IloBoolArray> matrizbin;
typedef IloArray<IloIntSet> vetorSet;
typedef IloArray<matrizvarnum> matriz2varnum;

ILOSTLBEGIN

using namespace std;

int usaModel=1, DecUtilGeral=1;

char* mudaModel(int modelo){
    usaModel=modelo;
    switch(modelo){
        case 1: return "Modelo SPL Stadtler";
            break;
        case 2: return "Modelo Agregado";
            break;
        case 3: return "Modelo SPL Sahling";
            break;
    }
}

char* mudaDecomp(int decomp){
    DecUtilGeral=decomp;
    switch(decomp){
        case 1: return "Decomposicao por itens";
            break;
        case 2: return "Decomposicao por periodos";
            break;
        case 3: return "Decomposicao por itens e depois por perodos";
            break;
        case 4: return "Decomposicao por periodos e depois por itens";
            break;
        case 5: return "Decomposicao por um periodo e por itens";
            break;
        default: return "Decomposicao desconhecida";
            break;
            
    }
}

int MLCLSP(IloEnv env, IloIntSet N, IloIntSet M, IloIntSet T, vetorSet K, vetorSet S, vetorSet A, matriznum r,matriznum C, matriznum B, matriznum d, vetornum oc, vetornum h, vetornum s, vetornum a, vetornum ts, vetornum lt, vetornum Iinic, IloModel *agregado, matrizvarnum *y){
    IloInt i,m,t;
    IloIntSet aux;
    IloNum soma;
    matriznum D(env,N.getSize()+1);
    vetorvarnum I0=IloNumVarArray(env,N.getSize()+1);
    *y = IloArray<IloNumVarArray>(env,N.getSize()+1);
    matrizvarnum O(env,M.getSize()+1), x(env,N.getSize()+1), I(env,N.getSize()+1), v(env,M.getSize()+1);
    for(i=1;N.contains(i);i++){
        D[i]=IloNumArray(env,T.getSize()+1);
        D[i][0]=IloNum(0.0);
        x[i]=IloNumVarArray(env,T.getSize()+1);
        I[i]=IloNumVarArray(env,T.getSize()+1);
        (*y)[i]=IloNumVarArray(env,T.getSize()+1);
        I0[i]=IloNumVar(env,0.0,IloInfinity,ILOFLOAT);
        for(t=1;T.contains(t);t++){
            D[i][t]=IloNum(0.0);
            x[i][t]=IloNumVar(env,0.0,IloInfinity,ILOFLOAT);
            I[i][t]=IloNumVar(env,0.0,IloInfinity,ILOFLOAT);
            (*y)[i][t]=IloNumVar(env,0,1,ILOBOOL);
        }
    }
    for(m=1;M.contains(m);m++){
        O[m]=IloNumVarArray(env,T.getSize()+1);
        v[m]=IloNumVarArray(env,T.getSize()+1);
        for(t=1;T.contains(t);t++){
            v[m][t]=IloNumVar(env,0.0,IloInfinity,ILOFLOAT);
            O[m][t]=IloNumVar(env,0.0,IloInfinity,ILOFLOAT);
        }
    }
    
    *agregado = IloModel(env);
    IloExpr obj(env);
    IloExpr restr(env);
    //clculo da demanda de escalo acumulada
    for(i=1;N.contains(i);i++){
        for(t=0;t!=T.getLast();t++){
            soma=0;
            if(t!=0)
                soma += d[i][t];
            for(IloIntSet::Iterator ite(S[i]);ite.ok();++ite)
                soma += r[i][*ite]*D[*ite][t+(int)lt[i]];
            D[i][t]=IloMax(0,soma);
        }
        if(lt[i]!=0)
            D[i][T.getLast()]=d[i][t];
        else{
            D[i][T.getLast()]=d[i][t];
            for(IloIntSet::Iterator ite(S[i]);ite.ok();++ite)
                D[i][T.getLast()]+= r[i][*ite]*D[*ite][t+(int)lt[i]];
        }
    }
    for(t=T.getLast();t>1;t--)
        for(i=1;N.contains(i);i++)
            D[i][t-1]+=D[i][t];
    //fim do clculo da demanda de escalo acumulada
    //Inicio da criao da funo objetivo
    obj.clear();
    for(i=1;N.contains(i);i++)
        for(t=1;T.contains(t);t++)
            obj+=s[i]*(*y)[i][t]+h[i]*I[i][t];
    for(m=1;M.contains(m);m++)
        for(t=1;T.contains(t);t++)
            obj+= oc[m]*O[m][t];
    agregado->add(IloMinimize(env, obj));
    //Funo Objetivo adicionada
    //Restrio (1)
    restr.clear();
    for(i=1;N.contains(i);i++){
        for(t=2;t!=T.getLast();t++){
            restr+=I[i][t-1]+x[i][t]-I[i][t];
            for(IloIntSet::Iterator ite(S[i]);ite.ok();++ite){
                restr-=r[i][*ite]*x[*ite][t+(int)lt[i]];
            }
            agregado->add(restr==d[i][t]);
            restr.clear();
        }
    }
    //Fim da restrio (1)
    //Restrio (2)
    restr.clear();
    for(i=1;N.contains(i);i++){
        restr+=I[i][T.getLast()-1]+x[i][T.getLast()]-I[i][T.getLast()];
        if(lt[i]==0)
            for(IloIntSet::Iterator ite(S[i]);ite.ok();++ite)
                restr-=r[i][*ite]*x[*ite][t+(int)lt[i]];
        agregado->add(restr==d[i][T.getLast()]);
        restr.clear();
    }
    //Fim da restrio (2)
    //Restrio (3)
    restr.clear();
    for(i=1;N.contains(i);i++){
        restr+=Iinic[i]-I0[i];
        if(lt[i]!=0)
            for(IloIntSet::Iterator ite(S[i]);ite.ok();++ite){
                restr-=r[i][*ite]*x[*ite][(int)lt[i]];
            }
        agregado->add(restr==0);
        restr.clear();
    }
    //Fim da restrio (3)
    //Restrio (4)
    restr.clear();
    for(i=1;N.contains(i);i++){
        restr+=I0[i]+x[i][1]-I[i][1];
        for(IloIntSet::Iterator ite(S[i]);ite.ok();++ite){
            restr-=r[i][*ite]*x[*ite][1+(int)lt[i]];
        }
        agregado->add(restr==d[i][1]);
        restr.clear();
    }
    
    //Fim da restrio (4)
    //Restrio (5)
    restr.clear();
    for(t=1;T.contains(t);t++)
        for(m=1;M.contains(m);m++){
            for(IloIntSet::Iterator ite(K[m]);ite.ok();++ite)
                restr+=a[*ite]*x[*ite][t]+ts[*ite]*(*y)[*ite][t];
            agregado->add(restr<=(C[m][t]+O[m][t]));
            restr.clear();
        }
    //Fim da restrio (5)
    //Restrio (6)
    for(t=1;T.contains(t);t++){
        for(i=1;N.contains(i);i++){
            agregado->add(x[i][t]<=D[i][t]*(*y)[i][t]);
        }
    }
    //Fim da restrio (6)

    return 0;
}


int solve_model(IloEnv env, IloIntSet N, IloIntSet M, IloIntSet T, vetorSet K, vetorSet S, vetorSet A, matriznum r,matriznum C, matriznum B, matriznum d, vetornum oc, vetornum h, vetornum s, vetornum a, vetornum ts, vetornum lt, vetornum Iinic){
    
    IloModel modelo;
    matrizvarnum y;
    //Monta Modelo
    MLCLSP(env, N, M, T, K, S, A, r, C, B, d, oc, h, s, a, ts, lt, Iinic, &modelo, &y);
    IloCplex cplex(modelo);
    cplex.setParam(IloCplex::TiLim,60);
    cplex.solve();
    return 0;
}


int LP_and_fix(IloEnv env, IloIntSet N, IloIntSet M, IloIntSet T, vetorSet K, vetorSet S, vetorSet A, matriznum r,matriznum C, matriznum B, matriznum d, vetornum oc, vetornum h, vetornum s, vetornum a, vetornum ts, vetornum lt, vetornum Iinic){

    IloModel modelo;
    matrizvarnum y;
    //Monta Modelo
    MLCLSP(env, N, M, T, K, S, A, r, C, B, d, oc, h, s, a, ts, lt, Iinic, &modelo, &y);
    //Relaxa as variveis
    IloExtractableArray relaxa(env);
    for(int t=1;t<=T.getSize();t++){
        for(int i=1;i<=N.getSize();i++){
            relaxa.add(IloConversion(env,y[i][t],ILOFLOAT));
        }
    }
    //Adiciona e resolve o modelo relaxado
    modelo.add(relaxa);
    IloCplex cplex(modelo);
    cplex.solve();
    //Salvar soluo
    matriznum sol(env,N.getSize()+1);
    for(int i=1;i<=N.getSize();i++){
        sol[i] = IloNumArray(env,T.getSize()+1);
        for(int t=1;t<=T.getSize();t++){
            sol[i][t] = cplex.getValue(y[i][t]);
        }
    }
    //Remove as relaxaes
    modelo.remove(relaxa);
    int fixaZero=0, fixaUm=0;
    for(int i=1;i<=N.getSize();i++){
        for(int t=1;t<=T.getSize();t++){
            if(sol[i][t]>=0.8){
                y[i][t].setBounds(1,1);
                fixaUm++;
            }else if(sol[i][t]<=0.02){
                y[i][t].setBounds(0,0);
                fixaZero++;
            }else{
                y[i][t].setBounds(0,1);
            }
        }
    }
    cout << "# var fixadas em zero "<< fixaZero <<endl;
    cout << "# var fixadas em um "<< fixaUm <<endl;
    cplex.setParam(IloCplex::TiLim,60);
    cplex.solve();
    if(cplex.getStatus()!=IloAlgorithm::Feasible && cplex.getStatus()!=IloAlgorithm::Optimal){
        cout << "Erro! Particao infactivel!" << endl;
        return -1;
    }
    return 0;
}

int Relax_and_fix(IloEnv env, IloIntSet N, IloIntSet M, IloIntSet T, vetorSet K, vetorSet S, vetorSet A, matriznum r,matriznum C, matriznum B, matriznum d, vetornum oc, vetornum h, vetornum s, vetornum a, vetornum ts, vetornum lt, vetornum Iinic){
    
    IloModel modelo;
    matrizvarnum y;
    //Monta Modelo
    MLCLSP(env, N, M, T, K, S, A, r, C, B, d, oc, h, s, a, ts, lt, Iinic, &modelo, &y);
    //Relaxa as variveis
    IloArray<IloExtractableArray> relaxa(env,N.getSize()+1);
    for(int i=1;i<=N.getSize();i++)
        relaxa[i] = IloExtractableArray(env,T.getSize()+1);
    for(int t=1;t<=T.getSize();t++){
        for(int i=1;i<=N.getSize();i++){
            relaxa[i][t] = IloConversion(env,y[i][t],ILOFLOAT);
        }
    }
    //Adiciona e resolve o modelo relaxado
    for(int t=1;t<=T.getSize();t++)
        for(int i=1;i<=N.getSize();i++)
            modelo.add(relaxa[i][t]);
    IloCplex cplex(modelo);
    cplex.setOut(env.getNullStream());
    IloNum objFO = IloInfinity;
    //Salvar soluo
    matriznum sol(env,N.getSize()+1);
    for(int i=1;i<=N.getSize();i++)
        sol[i] = IloNumArray(env,T.getSize()+1);
    //Relax-and-fix por perodos
    for(int t=1;t<=T.getSize();t++){
        cout << "Iteracao " << t << tab << objFO << endl;
        //Remove as relaxaes do perodo
        for(int i=1;i<=N.getSize();i++)
            modelo.remove(relaxa[i][t]);
        cplex.solve();
        if(cplex.getStatus()!=IloAlgorithm::Feasible && cplex.getStatus()!=IloAlgorithm::Optimal){
            cout << "Erro! Particao infactivel!" << endl;
            return -1;
        }
        objFO  = cplex.getObjValue();
        //Salva a parte inteira da soluo
        for(int i=1;i<=N.getSize();i++)
            sol[i][t] = cplex.getValue(y[i][t]);
        //Fixa a parte inteira da soluo
        for(int i=1;i<=N.getSize();i++){
            if(sol[i][t]>=0.8){
                y[i][t].setBounds(1,1);
            }else{
                y[i][t].setBounds(0,0);
            }
        }
    }
    cout << "Resultado Final " << objFO << endl;
    return 0;
}

int Fix_Opt(IloEnv env, IloIntSet N, IloIntSet M, IloIntSet T, vetorSet K, vetorSet S, vetorSet A, matriznum r,matriznum C, matriznum B, matriznum d, vetornum oc, vetornum h, vetornum s, vetornum a, vetornum ts, vetornum lt, vetornum Iinic){
    
    IloModel modelo;
    matrizvarnum y;
    //Monta Modelo
    MLCLSP(env, N, M, T, K, S, A, r, C, B, d, oc, h, s, a, ts, lt, Iinic, &modelo, &y);
    IloCplex cplex(modelo);
    cplex.setOut(env.getNullStream());
    IloNum objFO = IloInfinity;
    //Soluo inicial lote-por-lote
    matriznum sol(env,N.getSize()+1);
    for(int i=1;i<=N.getSize();i++){
        sol[i] = IloNumArray(env,T.getSize()+1);
        for(int t=1;t<=T.getSize();t++)
            sol[i][t]=1;
    }
    //fix-and-opt por perodos
    for(int t=1;t<=T.getSize();t++){
        cout << "Iteracao " << t << tab << objFO << endl;
        //Fixa a parte inteira da soluo
        for(int t2=1;t2<=T.getSize();t2++){
            for(int i=1;i<=N.getSize();i++){
                if(t2!=t){
                    if(sol[i][t2]>=0.8){
                        y[i][t2].setBounds(1,1);
                    }else{
                        y[i][t2].setBounds(0,0);
                    }
                }else{
                    y[i][t2].setBounds(0,1);
                }
            }
        }
        cplex.solve();
        objFO  = cplex.getObjValue();
        for(int i=1;i<=N.getSize();i++)
            sol[i][t]=cplex.getValue(y[i][t]);
        
    }
    cout << "Resultado Final " << objFO << endl;
    return 0;
}

int Ledados(IloEnv env,  int argc, char** argv){
    int tipoSol=1;
    ifstream inFile;
    inFile.open(argv[1]);
    if (!inFile.is_open()){
		cout << "Instancia de testes no encontrada!" << endl;
		return 100;
	}
	tipoSol=atoi(argv[7]);
	//Reading names and opening instance files
	fstream fset(argv[1]);
	fstream fcap(argv[2]);
	fstream fdem(argv[3]);
	fstream fsco(argv[4]);
	fstream fdat(argv[5]);
	fstream fres(argv[6]);
	//Testando se todos os arquivos de entrada abriram corretamente
	if(!fset.is_open() || !fcap.is_open() || !fdem.is_open() || !fsco.is_open() || !fdat.is_open() || !fres.is_open()){
		cout << "There are problems to read one or mode instance files!" << endl;
		cout << fset.is_open() << " " << fcap.is_open() << " " << fdem.is_open() << " " << fsco.is_open() << " " << fdat.is_open() << " " << fres.is_open() << endl;
		return 100;
	}
	//Criao das variaveis e alocao das mesmas
	IloInt i ,t ,m , numn, numm, numt, aux,cont,j, numi;
	fdat>>numn;
	fdat>>numm;
	fdat>>numt;
	IloIntSet N(env,numn);
	IloIntSet M(env,numm);
	IloIntSet T(env,numt);
	numn++;numm++;numt++;
	IloIntArray veti(env,numn);
	vetorSet  K(env,numm);
	vetorSet  S(env,numn);
	vetorSet  A(env,numn);
	IloNumArray lt(env, numn);
	matriznum r(env,numn), C(env,numm), B(env,numn), d(env,numn);
	vetornum oc(env,numm), h(env,numn), s(env,numn), a(env,numn), ts(env,numn), Iinic(env,numn);
	j=0;
	for(i=1;i<numn;i++){
		veti[i]=IloInt();
		lt[i]=IloNum();
		r[i]=IloNumArray(env,numn);
		B[i]=IloNumArray(env,numt);
		d[i]=IloNumArray(env,numt);
		h[i]=IloNum();
		s[i]=IloNum();
		a[i]=IloNum();
		ts[i]=IloNum();
		Iinic[i]=IloNum();
		S[i]=IloIntSet(env);
		A[i]=IloIntSet(env);
		for(t=1;t<numt;t++){
			B[i][t]=IloNum();
			d[i][t]=IloNum();
		}
		for(j=1;j<numn;j++)
			r[i][j]=IloNum();
	}
	for(m=1;m<numm;m++){
		C[m]=IloNumArray(env,numt);
		oc[m]=IloNum();
		K[m]=IloIntSet(env);
		for(t=1;t<numt;t++){
			C[m][t]=IloNum();
		}
	}
	for(i=1;i<numn;i++)
		N.add(i);
	for(t=1;t<numt;t++)
		T.add(t);
	for(m=1;m<numm;m++)
		M.add(m);
//Fim da criao das variaveis
//Leitura do arquivo dat
	for(i=1;i<numn;i++){
		fdat>>aux;
		fdat>>h[aux]>>a[aux]>>m;
		K[m].add(i);
	}
	
	fdat>>aux;
	for(cont=1;cont<=aux;cont++){
		fdat>>i>>j;
		fdat>>r[i][j]>>lt[i];
		S[i].add(j);
		A[j].add(i);
	}
//Fim da leitura do arquivo dat
//Leitura do arquivo cap
	for(m=1;m<numm;m++){
		fcap>>aux;
		for(t=1;t<numt;t++)
			fcap>>C[m][t];
	}
//Fim da leitura do arquivo cap
//Leitura do arquivo sco
	for(i=1;i<numn;i++){
		fsco>>aux;
		fsco>>s[aux];
	}
//Fim da leitura do arquivo sco
//Leitura do arquivo dem
	fdem>>numi;
	for(i=1;i<numn;i++){
		fdem>>veti[i];
	}
	for(t=1;t<numt;t++){
		fdem>>aux;
		for(i=1;i<=numi;i++){
			fdem>>d[veti[i]][t];
		}
	}
    
	float lixof;
	for(i=1;i<numn;i++){
		fdem>>aux;
		fdem>>Iinic[aux]>>lixof;
	}
//Fim da leitura do arquivo dem
//Leitura do arquivo set
	for(i=1;i<numn;i++){
		fset>>aux;
		fset>>ts[aux];
	}
//Fim da leitura do arquivo set
//Atribuindo valor ao B
	for(i=1;i<numn;i++)
		for(t=1;t<numt;t++)
			B[i][t]=BIGM;
//Fim da atribuicao

//Atribuindo valor de custo de hora-extra como BIGM
	for(m=1;m<numm;m++)
			oc[m]=BIGM;
//Fim da atribuicao
   
//Captura de limitantes
   float ub,lb;
   fres>>ub>>lb;
   
//cout << setprecision(4) << fixed << ub << tab <<lb << tab;
//Fim da captura

	fset.close();
	fcap.close();
	fdem.close();
	fsco.close();
	fdat.close();
	fres.close();
	switch(tipoSol){
        case 1: solve_model(env,N,M,T,K,S,A,r,C,B,d,oc,h,s,a,ts,lt,Iinic);
        break;
        case 2: LP_and_fix(env,N,M,T,K,S,A,r,C,B,d,oc,h,s,a,ts,lt,Iinic);
        break;
		case 3: Relax_and_fix(env,N,M,T,K,S,A,r,C,B,d,oc,h,s,a,ts,lt,Iinic);
        break;
        case 4: Fix_Opt(env,N,M,T,K,S,A,r,C,B,d,oc,h,s,a,ts,lt,Iinic);
        break;
	}

	N.end();
	M.end();
	T.end();
	veti.end();
	K.end();
	S.end();
	A.end();
	r.end();
	C.end();
	B.end();
	d.end();
	oc.end();
	h.end();
	s.end();
	a.end();
	ts.end();
	Iinic.end();
	return 0;
}

int main(int argc, char** argv) {
	try{
		IloEnv env;
		Ledados(env, argc, argv);
	}catch(IloException& e){
		cerr<<"Exceo capturada pelo Concert: "<<e<<endl;
	}catch(...){
		cerr<<"Erro de origem desconhecida"<<endl;
	}
	//getchar();
return 0;
}
